VERSION 5.00
Begin VB.Form fCairoDemo 
   Caption         =   "Cairo-Tutorial"
   ClientHeight    =   8055
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   10800
   LinkTopic       =   "Form1"
   ScaleHeight     =   8055
   ScaleWidth      =   10800
   StartUpPosition =   3  'Windows-Standard
   Begin VB.ComboBox cmbSource 
      Height          =   315
      ItemData        =   "fCairoDemo.frx":0000
      Left            =   2040
      List            =   "fCairoDemo.frx":000A
      Style           =   2  'Dropdown-Liste
      TabIndex        =   2
      Top             =   60
      Width           =   3285
   End
   Begin VB.CheckBox chkShowControlPoints 
      Caption         =   "Show ControlPoints"
      Height          =   315
      Left            =   90
      TabIndex        =   1
      Top             =   90
      Value           =   1  'Aktiviert
      Width           =   1815
   End
   Begin CairoTutorial.ucCanvas ucCanvas1 
      Height          =   4515
      Left            =   30
      TabIndex        =   0
      Top             =   480
      Width           =   8175
      _ExtentX        =   14420
      _ExtentY        =   7964
   End
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'This Masking-example shows the differences to "plain Clipping".
'Where Clipping is more or less an "On/Off-thingy", masking can
'do more, since it allows the definition of "gradual Blending-masks"
'over a dedicated Alpha-Channel - the AlphaMask we use here, is
'constructed with normal Drawing-Commands, encapsulated within
'the Object in the line below (but we could also "reuse" already
'existing Alpha-Channels as a Mask - e.g. from *.png-ImageResources)
Private MaskCircle As cMaskCircle
Attribute MaskCircle.VB_VarHelpID = -1


Private Sub Form_Load()
  Caption = "Drag the Control-Points"
  Me.ScaleMode = vbPixels

  'the mask-drawing-oprations are encapsulated this time within a separate Class
  Set MaskCircle = New cMaskCircle
  MaskCircle.Init ucCanvas1.ControlPoints, 350, 150, 100, -55
  
  'same image-resource as in the clipping-example
  Cairo.ImageList.AddImage "SourceImage", App.Path & "\cubes.jpg"
  
  cmbSource.ListIndex = 0
End Sub

Private Sub Form_Resize()
  If ScaleHeight - ucCanvas1.Top > 0 Then ucCanvas1.Move 0, ucCanvas1.Top, ScaleWidth, ScaleHeight - ucCanvas1.Top
End Sub

'------- the different "Control-Changed"-Events all doing the same refresh, a simple: Draw ucCanvas.CC ----------
Private Sub chkShowControlPoints_Click()
  Draw ucCanvas1.CC
End Sub

Private Sub cmbSource_Click()
  Draw ucCanvas1.CC
End Sub
'------------- End of "Control-Changed"-Event-Handling ------------------


Private Sub ucCanvas1_RefreshContents(CC As dhCairo.cCairoContext)
  Draw CC
End Sub

Private Sub Draw(CC As cCairoContext)

  'the following two lines ensure a complete Surface-Fill
  CC.SetSourceColor vbWhite
  CC.Paint
  
  CC.Save
    If cmbSource.ListIndex = 0 Then 'just the decision, which Source we place in CC, before our (clipped) CC.Paint
      CC.SetSourceColor vbCyan
    Else
      CC.SetSourceSurface Cairo.ImageList("SourceImage")
    End If
    
    CC.Mask MaskCircle.GetMaskPattern(CC)
  CC.Restore
  
  ucCanvas1.Refresh chkShowControlPoints.Value = 1
End Sub
